'From Squeak3.8 of ''5 May 2005'' [latest update: #6665] on 9 May 2006 at 1:45:40 am'!
TestCase subclass: #ExtendedClipboardSunit
	instanceVariableNames: 'interface'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'System-Clipboard-Extended'!

!ExtendedClipboardSunit methodsFor: 'testing' stamp: 'JSM 5/9/2006 00:43'!
testAddClipboardData
	| data |
	interface clearClipboard.
	interface addClipboardData:'hello' dataFormat: 'text'.
	interface addClipboardData:'bye' dataFormat: 'txt'.
	data := interface readClipboardData: 'text'.
	self should: data asString = 'hello'.
	data := interface readClipboardData: 'txt'.
	self should: data asString = 'bye'.
	interface clearClipboard.
	data := interface readClipboardData: 'text'.
	self should: data = nil.
	
	! !

!ExtendedClipboardSunit methodsFor: 'testing' stamp: 'JSM 5/9/2006 01:43'!
testClearClipboard
	| data |
	interface clearClipboard.
	data := interface readClipboardData: 'txt'.
	self assert: data = nil! !

!ExtendedClipboardSunit methodsFor: 'testing' stamp: 'JSM 5/9/2006 01:43'!
testGetClipboardFormat
	| data |
	interface clearClipboard.
	data := interface getClipboardFormat: 1.
	self assert: data = nil.
	interface clearClipboard.
	interface addClipboardData: 'hello' dataFormat: 'com.apple.traditional-mac-plain-text'.
	interface addClipboardData: 'bye' dataFormat: 'public.utf8-plain-text'.
	data := interface getClipboardFormat: 1.
	self should: data asText = 'public.utf8-plain-text'.
	data := interface getClipboardFormat: 0.
	self should: data asText = 'com.apple.traditional-mac-plain-text'! !


!ExtendedClipboardSunit methodsFor: 'initialize-release' stamp: 'JSM 5/6/2006 15:54'!
setUp
	interface _ ExtendedClipboardInterface current.
! !
